IF (	EXISTS(SELECT * FROM sys.columns    WHERE name = 'dt_envio' AND object_id = OBJECT_ID('pdv_vd_nfce'))
		AND EXISTS(SELECT * FROM sys.columns    WHERE name = 'qtd_envio' AND object_id = OBJECT_ID('pdv_vd_nfce'))
	)
BEGIN
    UPDATE C
	SET    C.dt_envio = COALESCE(C.DT_ENVIO, A.dt_cad),
		   C.qtd_envio = COALESCE(C.QTD_ENVIO,1)
	FROM   pdv_vd (nolock) V
		   INNER JOIN pdv_vd_cupons (nolock) A
				   ON A.nr_ecf = V.nr_ecf
					  AND A.dt_vd = V.dt_vd
					  AND A.cd_filial = V.cd_filial
					  AND A.cd_emp = V.cd_emp
		   INNER JOIN pdv_vd_nfce (nolock) C
				   ON C.nr_nf = A.nr_ecf
					  AND C.dt_vd = A.dt_vd
					  AND C.cd_emp = A.cd_emp
					  AND C.cd_filial = A.cd_filial
					  AND C.dt_envio IS NULL
	WHERE  V.cd_emp = 1
	AND (C.DT_ENVIO IS NULL OR C.QTD_ENVIO IS NULL)

END;

